/***************************************************************
Module NameCLS_NVDSDK_Interface.h
DescriptionExport the function of nvdsdk.dll
Version    v1.1
             compared with v1.0: from cb to vc
Time       2011-10-11 9:28:06
Author     gujinfei
Other      2011-10-11 9:28:43 
***************************************************************/

#ifndef CLS_NVDSDK_InterfaceH
#define CLS_NVDSDK_InterfaceH
//---------------------------------------------------------------------------
#include "CommonFun.h"
#include "DecCtrlClientTypes.h"

TYPEDEF_FUNCTION(DEC_ClientStartup)(UINT _uiMessage, HWND _hWnd);
TYPEDEF_FUNCTION(DEC_ClientCleanup)();
TYPEDEF_FUNCTION_RET(LONG, DEC_ClientLogon)(LPCSTR _cIP, LPCSTR _cUserName, LPCSTR _cPassword, WORD _nPort);
TYPEDEF_FUNCTION(DEC_ClientLogout)(LONG _ulID);
TYPEDEF_FUNCTION(DEC_ClientGetDecoderPara)(LONG _ulID, TDECPARAM *_pPara);
TYPEDEF_FUNCTION(DEC_ClientSetIP)(LONG _ulID, char* _cNewIP, char* _cMask, char* _cGateway, char* _cDNS);
TYPEDEF_FUNCTION(DEC_ClientSetDDNS)(LONG _ulID, char* _cSvrIP, char* _cUserName, char* _cPassword, int _iPort);
TYPEDEF_FUNCTION(DEC_ClientSetCom)(LONG _ulID, int _iType, int _iAddress, int _iBaudrate, int _iDatabit, int _iStopbit, int _iCheckbit, int _iFlowCtrl, int _iCom);
TYPEDEF_FUNCTION(DEC_ClientSetAlarmOut)(LONG _ulID, int _iAlarmOut, int _iAlarmMode);
TYPEDEF_FUNCTION(DEC_ClientSetTVInfo)(LONG _ulID, int _iIsPAL, int _iLanguage);
TYPEDEF_FUNCTION(DEC_ClientSetChannelMode)(LONG _ulID, int _iChannel, int _iMode);
TYPEDEF_FUNCTION(DEC_ClientSetLogo)(LONG _ulID, TLOGOPARAM* _logoParam);
TYPEDEF_FUNCTION(DEC_ClientGetLogo)(LONG _ulID, TLOGOPARAM* _logoParam);
TYPEDEF_FUNCTION(DEC_ClientGetLoopItemCount)(LONG _ulID, int _iChannel, int _iPos);
TYPEDEF_FUNCTION(DEC_ClientGetLoopItem)(LONG _ulID, int _iIndex, TNVSITEM *_pPara, int _iChannel, int _iPos);
TYPEDEF_FUNCTION(DEC_ClientSetLoopItem)(LONG _ulID, int _iIndex, TNVSITEM *_pPara, int _iChannel, int _iPos);
TYPEDEF_FUNCTION(DEC_ClientDelLoopItem)(LONG _ulID, int _iIndex, int _iChannel, int _iPos);
TYPEDEF_FUNCTION(DEC_ClientStartLoop)(LONG _ulID, int _iChannel, int _iPos);
TYPEDEF_FUNCTION(DEC_ClientStopLoop)(LONG _ulID, int _iChannel, int _iPos);
TYPEDEF_FUNCTION(DEC_ClientGetLoopStatus)(LONG _ulID, int _iChannel, int _iPos);
TYPEDEF_FUNCTION(DEC_ClientStartView)(LONG _ulID, TNVSITEM *_pPara, int _iChannel, int _iPos);
TYPEDEF_FUNCTION(DEC_ClientStopView)(LONG _ulID, int _iChannel, int _iPos, int _iShowLastPic);
TYPEDEF_FUNCTION(DEC_ClientGetViewItem)(LONG _ulID, TNVSITEM *_pPara, int _iChannel, int _iPos);
TYPEDEF_FUNCTION(DEC_ClientSendKeyCode)(LONG _ulID,int _keycode);
TYPEDEF_FUNCTION(DEC_ClientPTZCtrl)(LONG _ulID,int _iCtrlCode,int _iVal, int _iChannel, int _iPos);
TYPEDEF_FUNCTION(DEC_Client485Send)(LONG _ulID,CONST BYTE *_pData, int _iSize, int _iChannel, int _iPos);
TYPEDEF_FUNCTION(DEC_ClientGetPTZprotocols)(LONG _ulID, TDECPROTOCOL * _pProtocol);
TYPEDEF_FUNCTION(DEC_ClientSoundCtrl)(LONG _ulID, int _bOn, int _iChannel, int _iPos);
TYPEDEF_FUNCTION(DEC_ClientTalkServer)(LONG _ulID, int _bOn, int _iChannel, int _iPos);
TYPEDEF_FUNCTION(DEC_ClientGetAudioStatus)(LONG _ulID, int _iChannel, int _iPos);
TYPEDEF_FUNCTION(DEC_ClientGetTalkStatus)(LONG _ulID, int _iChannel, int _iPos);
TYPEDEF_FUNCTION(DEC_ClientRebootDecoder)(LONG _ulID);
TYPEDEF_FUNCTION(DEC_ClientResetDefault)(LONG _ulID);
TYPEDEF_FUNCTION(DEC_ClientUpgrade)(LONG _ulID, char *_cFileName);
TYPEDEF_FUNCTION(DEC_ClientUpgradeLogo)(LONG _ulID, char *_cFileName);
TYPEDEF_FUNCTION(DEC_ClientUpgradeProtocol)(LONG _ulID, char *_cFilePath, char *_cFileName);
TYPEDEF_FUNCTION(DEC_ClientDeleteProtocol)(LONG _ulID, char *_cProtocol);
TYPEDEF_FUNCTION(DEC_ClientUpgradeWeb)(LONG _ulID, char *_cFileName);
TYPEDEF_FUNCTION(DEC_ClientGetVersion)(LONG _ulID,char* _cVer);
TYPEDEF_FUNCTION(DEC_ClientGetSDKVersion)(NVDSDK_VERSION *_ver);
TYPEDEF_FUNCTION(DEC_ClientSetComRecvNotify)(DEC_COMRECV_NOTIFY _comRecvNotify);
TYPEDEF_FUNCTION(DEC_ClientGetCapability)(LONG _ulID,char* _cCap);  //add for guo wei 2010-1-8
TYPEDEF_FUNCTION(DEC_ClientStartPushStream)(long _ulID, int _iChannel, int _iPos, int _iEncodeMode, int _iVideoSize);
TYPEDEF_FUNCTION(DEC_ClientStartPushStreamEx)(long _ulID, int _iChannel, int _iPos, int _iEncodeMode, int _iVideoSize, char* _pcEncryptKey);

TYPEDEF_FUNCTION(DEC_ClientSendStream)(long _ulPushID, int _iLen, char* _cStreambuf);
TYPEDEF_FUNCTION(DEC_ClientStopPushStream)(long _ulPushID);
TYPEDEF_FUNCTION(DEC_ClientSetVGASize)(long _ulID, int _iChannel, int _iSize);
TYPEDEF_FUNCTION(DEC_ClientUserChangePassword)(long _ulID, char *_cUser, char *_cOldPassword, char *_cNewPassword);
TYPEDEF_FUNCTION(DEC_SetRegServer)(long _lID, char* _pcRegSvrIP, int _iRegSvrPort, int _iEnable);
TYPEDEF_FUNCTION(DEC_SetRegDevice)(long _lID, char* _pcPUID, char* _pcPUName);
TYPEDEF_FUNCTION(DEC_SetRegChannel)(long _lID, int _iChannelNum, char* _pcPUID);
TYPEDEF_FUNCTION(DEC_SetVolume)(long, int);
TYPEDEF_FUNCTION(DEC_SetSelectPicture)(int, int, int);
TYPEDEF_FUNCTION(DEC_SetDZInfo)(long _lID, DZ_INFO_PARAM* _pDzInfoParam);
TYPEDEF_FUNCTION(DEC_SetChannelSipConfig)(long _lID, int _iCmd, TSetSipVideoChannel* _lpBuf);
TYPEDEF_FUNCTION(DEC_SetPlatformStart)(long _lID, TPLATFORMINFO *_platformInfo);
TYPEDEF_FUNCTION(DEC_GetPlatformInfo)(long _lID, TPLATFORMINFO *_platformInfo);
TYPEDEF_FUNCTION(DEC_GetRunningPlatformInfo)(long _lID, TPLATFORMINFO *_platformInfo);

TYPEDEF_FUNCTION(DEC_ClientStartView_V1)(int _iID, int _iChannel, int _iPos, int _iServerType, ServerItem* _puItem);
TYPEDEF_FUNCTION(DEC_ClientStopView_V1)(int _iID, void* _pvPara , int _iBufSize);
TYPEDEF_FUNCTION(DEC_ClientGetViewItemEx)(long _ulID, TNVSITEMEX *_pPara, int _iChannel /*= 0*/, int _iPos /*= 0*/ );
TYPEDEF_FUNCTION(DEC_ClientGetViewItem_V1)(int _iID, int _iChannel, int _iPos, int* _piServerType, ServerItem* _puItem);
TYPEDEF_FUNCTION(DEC_ClientSetLoopItemEx)( long _ulID, int _iIndex, TNVSITEMEX *_pPara, int _iChannel /*= 0*/, int _iPos /*= 0*/);
TYPEDEF_FUNCTION(DEC_ClientSetLoopItem_V1)(int _iID, int _iChannel, int _iPos, int _iIndex, int _iServerType, ServerItem* _puItem);
TYPEDEF_FUNCTION(DEC_ClientGetLoopItem_V1)(int _iID, int _iChannel, int _iPos, int _iIndex, int* _piServerType, ServerItem* _puItem);
TYPEDEF_FUNCTION(DEC_ClientGetLoopItemEx)(int _iID, int _iIndex, TNVSITEMEX* _pPara, int _iChannel/* = 0*/, int _iPos/* = 0*/);

TYPEDEF_FUNCTION(DEC_ClientLogonEx)(char* _cIP, char* _cUserName, char* _cPassword, unsigned short _nPort /*= 3000*/, void* _pvUserData /*= NULL*/);
TYPEDEF_FUNCTION(DEC_ClientSendRawFrame)(long _ulPushID, int _iLen, char* _cStreambuf);
TYPEDEF_FUNCTION(DEC_ClientSetCommonEnable)(long _lID, int _iEnableID, int _iChannelNo, int _iEnableValue);
TYPEDEF_FUNCTION(DEC_ClientGetCommonEnable)(long _lID, int _iEnableID, int *_piEnableLastFrame, int *_piEnablePreference);
TYPEDEF_FUNCTION(DEC_ClientGetCommonEnableEx)(int _iID, int _iEnableID, int _iChannelNo, int* _piEnableValue);
TYPEDEF_FUNCTION(DEC_GetVolume)(long _lID, int *_piVolume);
TYPEDEF_FUNCTION(DEC_ClientGetStreamBufferState)(long _ulPushID, int * _piStreamBufferState);
TYPEDEF_FUNCTION(DEC_ClientStreamControl)(long  _ulPushID, int  _iCmd, void* _pvCmdBuf, int _iCmdLen);
TYPEDEF_FUNCTION(DEC_ClientSendNonstandardRawFrame)(long _ulPushID, int _iLen, char* _cStreambuf);
TYPEDEF_FUNCTION(DEC_ClientStopPushStreamEx)(long _ulPushID, int _iShowLastPic /*=0*/);
TYPEDEF_FUNCTION(DEC_ClientStartPushStream_V1)(long _ulID, int _iChannel, int _iPos, START_PUSH_PARAM *_pStartPushParam);
TYPEDEF_FUNCTION(DEC_ClientConfigStreamInfo)(long _ulID, int _iChannel, int _iPos, int _iCmd, void* _pvCmdBuf, int _iBuffSize);
TYPEDEF_FUNCTION(DEC_ClientGetDevConfig)(long _ulID, int _iChannel, int _iPos, int _iCmd, void* _pvCmdBuf, int _iBuffSize);
TYPEDEF_FUNCTION(DEC_ClientSetDevConfig)(long _ulID, int _iChannel, int _iPos, int _iCmd, void* _pvCmdBuf, int _iBuffSize);
TYPEDEF_FUNCTION(DEC_ClientNetLogQuery)(long _ulID, PDecLogQuery _logQuery, int _iSize);
TYPEDEF_FUNCTION(DEC_ClientNetLogGetLogfile)(long _ulID, int _iLogIndex, PDecLogData _pLogInfo, int _iSize);
TYPEDEF_FUNCTION(DEC_ClientNetLogGetLogCount)(long _ulID, int *_iTotalCount, int *_iCurrentCount);
TYPEDEF_FUNCTION(DEC_ClientGetClusterConfig)(long _iID, int _iCommand, void *_lpOutBuffer, int _iOutBufferSize, int* _iResultSize);
TYPEDEF_FUNCTION(DEC_ClientSetClusterConfig)(long _iID, int _iCommand, void *_lpInBuffer, int _iInBufferSize);
TYPEDEF_FUNCTION(DEC_ClientSetNotify)(DecNotifyFun *_pDecNotifyFun);
TYPEDEF_FUNCTION(DEC_ClientSendCommand)(long _iID, int _iChannel, int _iPos, int _iCommand, void* _pBuffer, int _iBufferSize);
TYPEDEF_FUNCTION(DEC_ClientRecvCommand)(long _iID, int _iChannel, int _iPos, int _iCommand, void* _pBuffer, int _iBufferSize);
TYPEDEF_FUNCTION(DEC_ClientGetLogonState)(long _iID);
TYPEDEF_FUNCTION(DEC_ClientSetSDKWorkMode)(int _iWorkMode);

class CLS_NVDSDK_Interface
{
private:
    static HINSTANCE s_tLibrary;
public:
    CLS_NVDSDK_Interface();
    ~CLS_NVDSDK_Interface();
    static CString m_szFilePath;
    static bool LoadDLL();
    static void FreeDLL();
};

DECLARE_FUNCTION(DEC_ClientStartup);
DECLARE_FUNCTION(DEC_ClientCleanup);
DECLARE_FUNCTION(DEC_ClientLogon);
DECLARE_FUNCTION(DEC_ClientLogout);
DECLARE_FUNCTION(DEC_ClientGetDecoderPara);
DECLARE_FUNCTION(DEC_ClientSetIP);
DECLARE_FUNCTION(DEC_ClientSetDDNS);
DECLARE_FUNCTION(DEC_ClientSetCom);
DECLARE_FUNCTION(DEC_ClientSetAlarmOut);
DECLARE_FUNCTION(DEC_ClientSetTVInfo);
DECLARE_FUNCTION(DEC_ClientSetChannelMode);
DECLARE_FUNCTION(DEC_ClientSetLogo);
DECLARE_FUNCTION(DEC_ClientGetLogo);
DECLARE_FUNCTION(DEC_ClientGetLoopItemCount);
DECLARE_FUNCTION(DEC_ClientGetLoopItem);
DECLARE_FUNCTION(DEC_ClientSetLoopItem);
DECLARE_FUNCTION(DEC_ClientDelLoopItem);
DECLARE_FUNCTION(DEC_ClientStartLoop);
DECLARE_FUNCTION(DEC_ClientStopLoop);
DECLARE_FUNCTION(DEC_ClientGetLoopStatus);
DECLARE_FUNCTION(DEC_ClientStartView);
DECLARE_FUNCTION(DEC_ClientStopView);
DECLARE_FUNCTION(DEC_ClientGetViewItem);
DECLARE_FUNCTION(DEC_ClientSendKeyCode);
DECLARE_FUNCTION(DEC_ClientPTZCtrl);
DECLARE_FUNCTION(DEC_Client485Send);
DECLARE_FUNCTION(DEC_ClientGetPTZprotocols);
DECLARE_FUNCTION(DEC_ClientSoundCtrl);
DECLARE_FUNCTION(DEC_ClientTalkServer);
DECLARE_FUNCTION(DEC_ClientGetAudioStatus);
DECLARE_FUNCTION(DEC_ClientGetTalkStatus);
DECLARE_FUNCTION(DEC_ClientRebootDecoder);
DECLARE_FUNCTION(DEC_ClientResetDefault);
DECLARE_FUNCTION(DEC_ClientUpgrade);
DECLARE_FUNCTION(DEC_ClientUpgradeLogo);
DECLARE_FUNCTION(DEC_ClientUpgradeProtocol);
DECLARE_FUNCTION(DEC_ClientDeleteProtocol);
DECLARE_FUNCTION(DEC_ClientUpgradeWeb);
DECLARE_FUNCTION( DEC_ClientGetVersion);
DECLARE_FUNCTION(DEC_ClientGetSDKVersion);
DECLARE_FUNCTION(DEC_ClientSetComRecvNotify);
DECLARE_FUNCTION(DEC_ClientGetCapability);    //add for guowei 2010-1-8
DECLARE_FUNCTION(DEC_ClientStartPushStream);    //add for pushStream 2010.4.20
DECLARE_FUNCTION(DEC_ClientSendStream);
DECLARE_FUNCTION(DEC_ClientStopPushStream);
DECLARE_FUNCTION(DEC_ClientSetVGASize);
DECLARE_FUNCTION(DEC_ClientUserChangePassword);
DECLARE_FUNCTION(DEC_SetRegServer);
DECLARE_FUNCTION(DEC_SetRegDevice);
DECLARE_FUNCTION(DEC_SetRegChannel);
DECLARE_FUNCTION(DEC_SetVolume);
DECLARE_FUNCTION(DEC_SetSelectPicture);
DECLARE_FUNCTION(DEC_SetDZInfo);
DECLARE_FUNCTION(DEC_SetChannelSipConfig);
DECLARE_FUNCTION(DEC_SetPlatformStart);
DECLARE_FUNCTION(DEC_GetPlatformInfo);
DECLARE_FUNCTION(DEC_GetRunningPlatformInfo);
DECLARE_FUNCTION(DEC_ClientNetLogQuery);
DECLARE_FUNCTION(DEC_ClientNetLogGetLogfile);
DECLARE_FUNCTION(DEC_ClientNetLogGetLogCount);
DECLARE_FUNCTION(DEC_ClientSetNotify);

//õĽӿ
DECLARE_FUNCTION(DEC_ClientStartView_V1);
DECLARE_FUNCTION(DEC_ClientStopView_V1);
DECLARE_FUNCTION(DEC_ClientGetViewItemEx);
DECLARE_FUNCTION(DEC_ClientGetViewItem_V1);
DECLARE_FUNCTION(DEC_ClientSetLoopItemEx);
DECLARE_FUNCTION(DEC_ClientSetLoopItem_V1);
DECLARE_FUNCTION(DEC_ClientGetLoopItemEx);
DECLARE_FUNCTION(DEC_ClientGetLoopItem_V1);

DECLARE_FUNCTION(DEC_ClientSendRawFrame);
DECLARE_FUNCTION(DEC_ClientStartPushStreamEx);
DECLARE_FUNCTION(DEC_ClientSetCommonEnable);
DECLARE_FUNCTION(DEC_ClientGetCommonEnable);
DECLARE_FUNCTION(DEC_ClientGetCommonEnableEx);
DECLARE_FUNCTION(DEC_GetVolume);
DECLARE_FUNCTION(DEC_ClientLogonEx);
DECLARE_FUNCTION(DEC_ClientGetStreamBufferState);
DECLARE_FUNCTION(DEC_ClientStreamControl);
DECLARE_FUNCTION(DEC_ClientSendNonstandardRawFrame);
DECLARE_FUNCTION(DEC_ClientStopPushStreamEx);
DECLARE_FUNCTION(DEC_ClientStartPushStream_V1);
DECLARE_FUNCTION(DEC_ClientConfigStreamInfo);
DECLARE_FUNCTION(DEC_ClientGetDevConfig);
DECLARE_FUNCTION(DEC_ClientSetDevConfig);
DECLARE_FUNCTION(DEC_ClientGetClusterConfig);
DECLARE_FUNCTION(DEC_ClientSetClusterConfig);
DECLARE_FUNCTION(DEC_ClientSendCommand);
DECLARE_FUNCTION(DEC_ClientRecvCommand);
DECLARE_FUNCTION(DEC_ClientGetLogonState);
DECLARE_FUNCTION(DEC_ClientSetSDKWorkMode);

typedef union tagMainNotifyParam
{
	int iStatus;
	PushStreamResponse tPushStreamResponse;
	int iUserPassResult;
	int iUpgradeState;
	int iUpgradeProgress;
	ClusterSearchResult tClusterSearchResult;
	int iPushId;
	PicSnapResult		tPicSnapResult;
	PicSnapFileName		tPicSnapFileName;
	ScreenCtlResult		tScreenCtlResult;
	RebootTradeResult	tRebootTradeResult;
	UDiskVideoList		tUDiskVideoList;
	VideoPlayCmdResult  tVideoPlayCmdResult;      
}MainNotifyParam, *PMainNotifyParam;
struct _MAIN_NOTIFY_DATA 
{
	unsigned long m_lID;
	unsigned int m_iMsg;
	unsigned int m_iChannel;
	int m_iPos; 
	MainNotifyParam tParam;
	void* m_pvUserData;
};

typedef union tagChangeParamNotifyParam
{
	TDECPARAM		  tDecParam;
	ScreenCtlProtocol tScreenCtlProtocol;
	PlanLoop          tPlanLoop;
	PlanLoopStatus	  tPlanLoopStatus;
	UDiskSetChannelVideo tUDiskSetChannelVideo;
}ChangeParamNotifyParam, *PChangeParamNotifyParam;

struct _CHANGE_PARAM_NOTIFY_DATA 
{
	unsigned long m_lID;
	unsigned int m_iMsg;
	unsigned int m_iChannel;
	int m_iPos; 
	ChangeParamNotifyParam tParam;
	void* m_pvUserData;
};
#endif
